# Руководство пользователя — Suri Oculus AI Модуль

Это руководство описывает, как использовать веб-интерфейс и API модуля интеллектуального анализа сетевого трафика Suricata.

---

## 🔗 Доступ к модулю

После запуска `run.sh`:

- Веб-интерфейс: [http://localhost:8000](http://localhost:8000)
- API: [http://localhost:5000](http://localhost:5000)

---

## 🖥️ Веб-интерфейс

Главная страница включает вкладки по типам событий:

### 1. **Flow Events**
- Анализ аномалий по статистике сетевых потоков (`flow`)
- Визуализация графиков аномалий по времени
- Сравнение "Сегодня vs Вчера"
- Ручной анализ JSON-событий

### 2. **TLS Events**
- Анализ JA3, JA3S, SNI и других TLS-параметров
- Интерфейс аналогичен вкладке Flow

### 3. **DNS Events**
- Анализ параметров DNS-запросов и ответов
- Графики и сравнение аналогичны

### 4. **HTTP Events**
- Анализ длины URL, user-agent, кодов ответа, размера
- Используются flow и http поля одновременно

### 5. **Комплексный анализ (Meta)**
- Использует все типы трафика
- Строит интегральную модель поведения
- Позволяет выявить мультианомалии

### 6. **Мульти-анализ**
- Отображает мультианомалии (2+ типов в 1 минуту)
- Отображение графика, списка аномалий
- Возможность пометить мультианомалию как *эскалированную*
- Отправка уведомлений (email) при активации

---

## 📥 Режим ручного анализа

На всех вкладках есть поле `Вставьте JSON-массив событий`:

- Можно скопировать и вставить JSON из любого источника (файл, логи)
- Формат: массив объектов Suricata (`[{ "flow": {...} }, ...]`)
- После анализа выводятся результаты и список аномалий

---

## 📊 Экспорт

- Результаты анализа можно выгрузить в `CSV` и `JSON`
- Используется для последующего анализа или отчетов

---

## ⏱️ Временные графики

- Интервал выбирается: **по минутам**, **по часам**, **по дням**
- Графики показывают динамику числа аномалий
- Доступны сравнения между сегодня и вчера

---

## 🧠 Комплексный анализ (Мета-модель)

- Вычисляет сводную метрику поведения за интервал времени (по умолчанию 60 минут)
- Признаки: количество аномалий по каждому типу, число уникальных IP
- Позволяет выявлять "странные дни" в поведении сети

---

## 🔁 Автообновление

По умолчанию автообновление включено каждые 2 минуты. Его можно отключить вручную.

---

## 📤 Эскалация мультианомалий

Во вкладке **Комплексный анализ мультианомалий** можно:

- Отметить мультианомалию как *эскалированную*
- При наличии SMTP-конфигурации будет отправлено email-уведомление

---

## 🛑 Возможные ошибки

- `Model not found`: отсутствует `.pkl` файл → выполните `--retrain`
- Redis не работает: убедитесь, что сервис запущен на `localhost:6379`
- Ошибка JSON: проверьте корректность формата

---

## ℹ️ Советы

- Для продуктивного анализа запускайте Suricata с выводом в Redis (`eve-log` → `redis`)
- Периодически переобучайте модели (`--retrain`) при изменении профиля сети
- Не забудьте защитить порт 5000 при удалённом доступе (рекомендуется использовать reverse proxy)

---
---

## 📦 Интеграция с Suricata и daemonmove

AI-модуль работает с потоками, поступающими в Redis. Для этого необходимо:

1. Установить и настроить **Suricata** на целевой системе
2. Установить и запустить демон **daemonmove**:
   - Он читает события Suricata
   - Преобразует их в формат JSON
   - Сохраняет данные в Redis

Это ключевое условие работы всего AI-модуля.

Подробнее: [https://suri-oculus.com/docs/log-parser-daemonmove-service/](https://suri-oculus.com/docs/log-parser-daemonmove-service/)
---
