# Suri Oculus — AI модуль анализа сетевого трафика

**Suri Oculus AI Module** — это автономный модуль для интеллектуального анализа событий сетевого трафика Suricata (Flow, HTTP, DNS, TLS) с использованием алгоритмов машинного обучения.

Модуль предоставляет REST API и web-интерфейс для анализа, визуализации и обработки аномалий в сетевом трафике.

---

## 🧠 Основные возможности

- Анализ сетевых событий (flow, http, dns, tls) на наличие аномалий
- Мета-анализ поведения по совокупности потоков
- Выявление мультианомалий — одновременных аномалий в нескольких потоках
- Визуализация по временным шкалам, сравнение по дням/часам
- Интерактивный веб-интерфейс (HTML+JavaScript)
- REST API на FastAPI
- Обработка данных из Redis или вручную (JSON)
- Экспорт результатов в CSV и JSON
- Защищённый C++ модуль для извлечения признаков (бинарный .so-файл)

---

## 📁 Структура проекта

suri-oculus-ai/
├── ai_rest_api.py # API-сервер
├── *.py # Анализаторы: flow, http, dns, tls, meta
├── *.pkl, *_features.txt # Обученные модели и признаки
├── cpplib/libsuri_features.so # C++ библиотека (исходники не включены)
├── web/ # Веб-интерфейс (HTML, JS, CSS)
├── run.sh # Скрипт запуска
├── install.sh # Скрипт установки


---

## ⚙️ Требования

- Python 3.9+
- Redis (локально на `localhost:6379`)
- Пакеты из `requirements.txt`:
  - `fastapi`
  - `uvicorn`
  - `pandas`
  - `joblib`
  - `scikit-learn`
  - `plotly`
  - `numpy`

---

## 🔗 Внешние зависимости

Для корректной работы AI-модуля необходимо:

- Запущенная система обнаружения вторжений **Suricata**
- Установленный и запущенный демон **daemonmove**

### Что такое daemonmove?

`daemonmove` — это фоновый сервис, разработанный в рамках проекта Suri Oculus. Он обеспечивает:

- приём логов из Suricata напрямую через `unix-socket` или `eve.json`,
- преобразование событий Suricata в формат JSON,
- передачу логов в Redis для последующего анализа AI-модулем.

Подробности установки и настройки доступны в официальной документации:  
👉 https://suri-oculus.com/docs/log-parser-daemonmove-service/

## 🚀 Установка и запуск

```bash
# 1. Распакуйте архив
tar -xzf suri-oculus-ai.tar.gz
cd suri-oculus-ai

# 2. Запустите установку
./install.sh

# 3. Запустите модуль
Замечание перед запуском модуля

Перед использованием скрипта run.sh необходимо выполнить ручные корректировки:

В файле config.js (строка с backendUrl) нужно заменить http://127.0.0.1:5000 на реальный IP-адрес сервера, на котором развёрнут backend-модуль. В противном случае фронтенд не сможет подключиться к API.

В файле run.sh (строка запуска HTTP-сервера) требуется указать реальный путь к директории web, где лежат файлы интерфейса:

# Start simple HTTP-server for frontend
python3 -m http.server 8000 --directory /path_to_web_folder


Иначе веб-сервер не найдёт фронтенд и интерфейс не будет доступен.
./run.sh
После запуска:

API будет доступен по адресу: http://localhost:5000

Web-интерфейс: http://localhost:8000

🔍 Использование
Модуль может быть использован:

как инструмент анализа в режиме offline (ручной JSON-анализ)

как дополнение к Suricata в продуктивной сети (через Redis)

как демонстрация применения AI к сетевым данным

🛠 CLI режим
Вы можете запускать каждый модуль отдельно:


python3 main.py dns --analyze
python3 main.py flow --retrain
python3 main.py meta --train --windows 200 --window_size 60
📬 Контакты и поддержка
Проект: https://suri-oculus.com
Telegram (RU): https://t.me/suri_oculus

© 2025, Suri Oculus Project. Все права защищены.

